package w83b.w83bManager;

import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.w83bBeans.W83bImpugnacionBean;
import w83b.w83bBeans.W83bNuevaIncidenciasBean;
import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.W83bFactoriaDAO;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistro;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistroException;


public class W83bComunes implements W83bIComunes {
	public w83b.w83bBeans.W83bUsuarioXLNetsBean buscarDatosUsuario(w83b.w83bBeans.W83bUsuarioXLNetsBean param) throws Exception{
		
		W83bUsuarioXLNetsBean usuario = new W83bUsuarioXLNetsBean();
		
		List listaUsuario = W83bFactoriaDAO.getComunesDAO().buscarDatosUsuario(param);
		
		if(null!=listaUsuario&& listaUsuario.size()>0){
			usuario = (W83bUsuarioXLNetsBean)listaUsuario.get(0);
		}else{
			usuario = param;
		}
		
		return usuario;	
	}
	
	
	public w83b.w83bBeans.W83bUsuarioXLNetsBean darAltaRegistroNuevoNumeroEntradaDelegacion(w83b.w83bBeans.W83bUsuarioXLNetsBean param) throws Exception{
		
		W83bUsuarioXLNetsBean usuario = new W83bUsuarioXLNetsBean();
		
		usuario = refrescarUsuarioDelegacion(param);
		
		String anyoActa = usuario.getObservaciones().split("/")[1];
		String territorioActa = usuario.getObservaciones().split("/")[0];
		
		String numActa = usuario.getObservaciones().split("/").length==3 ? usuario.getObservaciones().split("/")[2] : "";
		
		if("actas".equals(usuario.getTipo())){
			numActa = ((W83bIActas)(W83bActas.class.newInstance())).calcularNumActa(numActa, anyoActa, territorioActa);//NOPMD
			if("-1".equals(numActa)){
				usuario.setNumRegistro("-1");
				usuario.setFechaRegistro("-1");
				
				return usuario;	
			}
			usuario.setObservaciones("Acta n: "+territorioActa+"/"+anyoActa+"/"+numActa);
			usuario.setPoblacion(territorioActa);
		}else if("preavisos".equals(usuario.getTipo())){
			W83bPreavisosBean beanPreaviso = new W83bPreavisosBean();
			
			beanPreaviso.setAnyoPreaviso(anyoActa);
			beanPreaviso.setCodTerritorio(territorioActa);
			beanPreaviso.setNum_preaviso(numActa);
			
			HashMap mapaPreavisos = ((W83bIPreavisos)(W83bPreavisos.class.newInstance())).calcularNumPreaviso(beanPreaviso);
			
			numActa = (String)mapaPreavisos.get("numPreaviso");
			
			if("-1".equals(numActa)){
				usuario.setNumRegistro("-1");
				usuario.setFechaRegistro("-1");
				
				return usuario;	
			}
			usuario.setObservaciones("Preavisos n: "+territorioActa+"/"+anyoActa+"/"+numActa);
			usuario.setPoblacion(territorioActa);
			
			String empresa = usuario.getEmpresa();
			
			String[] codsPromotores= empresa.split(",");
			 StringBuffer codPromotores = new StringBuffer(W83bClsConstantes.UNO);				 
			 
			 codPromotores.append(codsPromotores[0]);
			 
			for (int j=0;j<codsPromotores.length;j++){
				codPromotores.append("-").append(codsPromotores[j]);				
			}
			empresa = codPromotores.toString();
			usuario.setEmpresa(empresa);
		}else if("impugnaciones".equals(usuario.getTipo())){
			W83bImpugnacionBean beanImpugnacion = new W83bImpugnacionBean();
			
			beanImpugnacion.setAnyoImpugnacion(anyoActa);
			beanImpugnacion.setTerritorioImpugnacion(territorioActa);
			beanImpugnacion.setNumImpugnacion(numActa);
			
			W83bIImpugnaciones iImpugnaciones = ((W83bIImpugnaciones)(W83bImpugnaciones.class.newInstance()));
			boolean existeImpugnacion = false;
			
			if(StringUtils.isNotEmpty(numActa)){
				existeImpugnacion = iImpugnaciones.existeImpugnacion(beanImpugnacion);
			}
			
			if(existeImpugnacion){
				usuario.setNumRegistro("-1");
				usuario.setFechaRegistro("-1");
				
				return usuario;	
			}
			
			numActa = iImpugnaciones.calcularNumImpugnacion(beanImpugnacion);
			if("-1".equals(numActa)){
				usuario.setNumRegistro("-1");
				usuario.setFechaRegistro("-1");
				
				return usuario;	
			}
			usuario.setObservaciones("Impugnaciones n: "+territorioActa+"/"+anyoActa+"/"+numActa);
			usuario.setPoblacion(territorioActa);

		}else if("incidencias".equals(usuario.getTipo())){
			W83bNuevaIncidenciasBean incidencia = new W83bNuevaIncidenciasBean();
			
			incidencia.setIncidenciaAnyo(anyoActa);
			incidencia.setIncidenciaTerritorio(territorioActa);
			incidencia.setIncidenciaNumero(numActa);

			
			if(StringUtils.isEmpty(incidencia.getIncidenciaNumero())){
				incidencia.setIncidenciaNumero(
						String.valueOf(
								Integer.parseInt(W83bFactoriaDAO.getIncidenciasDAO().maxIncidencia(incidencia.getIncidenciaAnyo(),incidencia.getIncidenciaTerritorio()))+1
								)
						);
				numActa = incidencia.getIncidenciaNumero();
			}
			
			usuario.setObservaciones("Incidencia n: "+territorioActa+"/"+anyoActa+"/"+numActa);
			
			if(StringUtils.isEmpty(usuario.getEmpresa())){
				usuario.setEmpresa(territorioActa+"/"+anyoActa+"/"+numActa);
			}
			usuario.setPoblacion(territorioActa);
		}
		
		String[] resul = null;
		
		
		try{
			resul = W83bLibroRegistro.getAltaRegistro(true, usuario.getModelo(), "E", "E", usuario.getEmpresa(), usuario.getPoblacion(), "", usuario.getObservaciones(), usuario);
			usuario.setObservaciones(numActa);
		}catch (W83bLibroRegistroException e) {
			
		}
		if(null!=resul){
			usuario.setNumRegistro(resul[0]);
			usuario.setFechaRegistro(resul[1]);
		}else{
			usuario.setNumRegistro(null);
			usuario.setFechaRegistro(null);
		}
		
		return usuario;	
	}
	
	public w83b.w83bBeans.W83bUsuarioXLNetsBean refrescarUsuarioDelegacion(w83b.w83bBeans.W83bUsuarioXLNetsBean param) throws Exception{
		
		W83bUsuarioXLNetsBean usuario = new W83bUsuarioXLNetsBean();
		
		List listaUsuario = W83bFactoriaDAO.getComunesDAO().buscarDatosUsuarioLimitado(param);
		
		if(null!=listaUsuario&& listaUsuario.size()>0){
			usuario = (W83bUsuarioXLNetsBean)listaUsuario.get(0);
		}else{
			usuario = param;
		}
		
		return usuario;	
	}
	
	public w83b.w83bBeans.W83bUsuarioXLNetsBean refrescarRegistroAutomaticoUsuarioDelegacion(w83b.w83bBeans.W83bUsuarioXLNetsBean param) throws Exception{
		
		W83bUsuarioXLNetsBean usuario = new W83bUsuarioXLNetsBean();
		
		List listaUsuario = W83bFactoriaDAO.getComunesDAO().buscarDatosUsuarioLimitadoRegistroAutomat(param);
		
		if(null!=listaUsuario&& listaUsuario.size()>0){
			usuario = (W83bUsuarioXLNetsBean)listaUsuario.get(0);
		}else{
			usuario = param;
		}
		
		return usuario;	
	}
	

}